<?php

namespace Drupal\admin_guide\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the admin guide entity edit forms.
 */
class AdminGuideForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {

    $entity = $this->getEntity();
    $result = $entity->save();
    $link = $entity->toLink($this->t('View'))->toRenderable();

    $message_arguments = ['%label' => $this->entity->label()];
    $logger_arguments = $message_arguments + ['link' => \Drupal::service('renderer')->render($link)];

    if ($result == SAVED_NEW) {
      $this->messenger()->addStatus($this->t('New admin guide %label has been created.', $message_arguments));
      $this->logger('admin_guide')->notice('Created new admin guide %label', $logger_arguments);
    }
    else {
      $this->messenger()->addStatus($this->t('The admin guide %label has been updated.', $message_arguments));
      $this->logger('admin_guide')->notice('Updated new admin guide %label.', $logger_arguments);
    }

    $form_state->setRedirect('entity.admin_guide.canonical', ['admin_guide' => $entity->id()]);
  }

}
