<?php

namespace Drupal\admin_guide;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Defines a class to build a listing of admin guide type entities.
 *
 * @see \Drupal\admin_guide\Entity\AdminGuideType
 */
class AdminGuideTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['title'] = $this->t('Label');

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['title'] = [
      'data' => $entity->label(),
      'class' => ['menu-label'],
    ];

    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();

    $build['table']['#empty'] = $this->t(
      'No admin guide types available. <a href=":link">Add admin guide type</a>.',
      [':link' => Url::fromRoute('entity.admin_guide_type.add_form')->toString()]
    );

    return $build;
  }

}
