<?php

namespace Drupal\admin_guide;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\user\EntityOwnerInterface;
use Drupal\Core\Entity\EntityChangedInterface;

/**
 * Provides an interface defining an admin guide entity type.
 */
interface AdminGuideInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * Gets the admin guide title.
   *
   * @return string
   *   Title of the admin guide.
   */
  public function getTitle();

  /**
   * Sets the admin guide title.
   *
   * @param string $title
   *   The admin guide title.
   *
   * @return \Drupal\admin_guide\AdminGuideInterface
   *   The called admin guide entity.
   */
  public function setTitle($title);

  /**
   * Gets the admin guide creation timestamp.
   *
   * @return int
   *   Creation timestamp of the admin guide.
   */
  public function getCreatedTime();

  /**
   * Sets the admin guide creation timestamp.
   *
   * @param int $timestamp
   *   The admin guide creation timestamp.
   *
   * @return \Drupal\admin_guide\AdminGuideInterface
   *   The called admin guide entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Returns the admin guide status.
   *
   * @return bool
   *   TRUE if the admin guide is enabled, FALSE otherwise.
   */
  public function isEnabled();

  /**
   * Sets the admin guide status.
   *
   * @param bool $status
   *   TRUE to enable this admin guide, FALSE to disable.
   *
   * @return \Drupal\admin_guide\AdminGuideInterface
   *   The called admin guide entity.
   */
  public function setStatus($status);

}
