<?php

namespace Drupal\admin_guide;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the admin guide entity type.
 */
class AdminGuideAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {

    switch ($operation) {
      case 'view':
        return AccessResult::allowedIf(($entity->get('status')->getValue()['0']['value'] && $account->hasPermission('view admin guide')) || $account->hasPermission('edit admin guide') || $account->hasPermission('administer admin guide') || $account->hasPermission('delete admin guide'));

      case 'update':
        return AccessResult::allowedIfHasPermissions($account, ['edit admin guide', 'administer admin guide'], 'OR');

      case 'delete':
        return AccessResult::allowedIfHasPermissions($account, ['delete admin guide', 'administer admin guide'], 'OR');

      default:
        // No opinion.
        return AccessResult::neutral();
    }

  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermissions($account, ['create admin guide', 'administer admin guide'], 'OR');
  }

}
