<?php

namespace Drupal\admin_guide\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form handler for admin guide listing exposed filters.
 */
class AdminGuideExposedFilters extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'admin_guide_exposed_filters';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $request = \Drupal::request();
    // Get available admin guide types for the Type select filter
    $adminGuideStorage = \Drupal::entityTypeManager()->getStorage('admin_guide_type');
    $ids = $adminGuideStorage->getQuery()->accessCheck(FALSE)->execute();
    $types = $adminGuideStorage->loadMultiple($ids);
    $labels = [];
    foreach ($types as $type => $value) {
      $labels[$type] = $value->get('label');
    }
    $type =  ['0' => t('- Any -')] + $labels;

    $form = [];

    $form = [
      '#suffix' => '<br />',
    ];

    $form['filters'] = [
      '#type' => 'container',
      '#attributes' => [
        'class' => ['form--inline', 'clearfix'],
      ],
    ];

    $form['filters']['title'] = [
      '#title' => t('Title'),
      '#type' => 'textfield',
      '#default_value' => $request->get('title'),
    ];

    $form['filters']['type'] = [
      '#type' => 'select',
      '#title' => t('Type'),
      '#options' => $type,
      '#default_value' => $request->get('type') ?? 0,
    ];
    
    $form['actions'] = [
      '#type' => 'container',
    ];
   
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => 'Filter',
    ];

    if ($request->getQueryString()) {
      $form['actions']['reset'] = [
        '#type' => 'submit',
        '#value' => 'Reset',
        '#submit' => ['::resetForm'],
      ];
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $query = [];
    $title = $form_state->getValue('title') ?? 0;
    $type = $form_state->getValue('type') ?? 0;
    if ($title) {
      $query['title'] = $title;
    }
    if ($type) {
      $query['type'] = $type;
    }
    $form_state->setRedirect('entity.admin_guide_listing', $query);
  }

  /**
   * {@inheritdoc}
   */
  public function resetForm(array $form, FormStateInterface &$form_state) {
    $form_state->setRedirect('entity.admin_guide_listing');
  }
}
