<?php

namespace Drupal\admin_guide\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Admin Guide type configuration entity.
 *
 * @ConfigEntityType(
 *   id = "admin_guide_type",
 *   label = @Translation("Admin Guide type"),
 *   handlers = {
 *     "form" = {
 *       "add" = "Drupal\admin_guide\Form\AdminGuideTypeForm",
 *       "edit" = "Drupal\admin_guide\Form\AdminGuideTypeForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *     "list_builder" = "Drupal\admin_guide\AdminGuideTypeListBuilder",
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     }
 *   },
 *   admin_permission = "administer admin guide types",
 *   bundle_of = "admin_guide",
 *   config_prefix = "admin_guide_type",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "add-form" = "/admin/structure/admin_guide_types/add",
 *     "edit-form" = "/admin/structure/admin_guide_types/manage/{admin_guide_type}",
 *     "delete-form" = "/admin/structure/admin_guide_types/manage/{admin_guide_type}/delete",
 *     "collection" = "/admin/structure/admin_guide_types"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "uuid",
 *   }
 * )
 */
class AdminGuideType extends ConfigEntityBundleBase {

  /**
   * The machine name of this admin guide type.
   *
   * @var string
   */
  protected $id;

  /**
   * The human-readable name of the admin guide type.
   *
   * @var string
   */
  protected $label;

}
